# Docker Ubuntu based SteamVR
An example of Steam and SteamVR working within an Ubuntu Docker container

## Requirements
Make sure that you have `nvidia-container-toolkit` installed.

Follow this guide to install `nvidia-container-toolkit`:
https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/latest/install-guide.html

## Building
Build container with:
```bash
make dev
```
Enter container with:
```bash
docker exec -it --privileged steamvr_dev_<user>_<branch> bash
```

## Running First time
### Setup Steam and SteamVR
 - Open steam (running `steam` in the container) and login to steam. Install SteamVR.
 - Run disable_steamvr_windows.sh to prevent the appearance of non-responsive windows (https://github.com/ValveSoftware/SteamVR-for-Linux/issues/577).
 - Launch SteamVR: `$HOME/.steam/debian-installation/steamapps/common/SteamVR/bin/vrmonitor.sh`
 - Set default runtime from the pop-up window:<br><img src="../doc/images/steamvr_openxr_runtime_popup.png" width=320>.
 - SteamVR is ready to use.
### Setup conda environment to run in VR
 - Navigate to `/home/${USER}/bigym/`
 - Activate bigym conda environments: `conda activate bigym`
 - Install dependencies: `pip install -e ".[dev]"`
 - Run demo collection tool: `python tools/demo_recorder/main.py`
